<?php if ( !defined('WPINC') ) die();
/**
 * Active Theme: Divi
 *
 * @link              http://infinitumform.com/
 * @since             1.2.4
 * @package           Serbian_Transliteration
 * @author            Ivijan-Stefan Stipic
 */
if(!class_exists('Serbian_Transliteration__Theme__divi')) :
	class Serbian_Transliteration__Theme__divi extends Serbian_Transliteration
	{
		
		/* Run this script */
		public static function run($dry = false) {
			$class = self::class;
			$instance = Serbian_Transliteration_Cache::get($class);
			if ( !$instance ) {
				$instance = Serbian_Transliteration_Cache::set($class, new self($dry));
			}
			return $instance;
		}
		
		function __construct($dry = array()){
			if($dry) return;
			$this->add_filter('rstr/transliteration/exclude/filters', array(get_class(), 'filters'));
		} 
		
		public static function filters ($filters=array()) {

			$classname = self::run(true);
			$filters = array_merge($filters, array(
				'et_before_main_content' => 'content',
				'et_after_main_content' => 'content',
				'et_before_content' => 'content',
				'et_html_top_header' => 'content',
				'et_html_slide_header' => 'content',
				'et_header_top' => 'content',
				'et_html_main_header' => 'content'
			));
			
			return $filters;
		}
	}
endif;